/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWConfigNewQueueDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    protected JLabel m_nameLabel = new JLabel();
    protected JTextField m_nameTextField = new JTextField();
    protected JLabel m_typeLabel = new JLabel();
    protected JLabel m_type = new JLabel();
    protected JLabel m_descriptionLabel = new JLabel();
    protected JTextArea m_descriptionTextArea = new JTextArea();
    protected JButton m_createButton = new JButton(VWResource.Create);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    private VWConfigBaseNode m_configNode = null;
    private VWConfigQueueNode m_newQueue = null;
    private int m_queueType;

    public VWConfigNewQueueDialog(Frame parent, int type, VWConfigBaseNode configNode) {
        super(parent);
        this.setTitle(VWResource.NewQueue);
        Dimension dim = VWStringUtils.stringToDimension("445,275");
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel panel = this.createTopPanel();
        subPanel.add((Component)panel, "First");
        panel.getAccessibleContext().setAccessibleParent(subPanel);
        panel = this.createDescriptionPanel();
        subPanel.add((Component)panel, "Center");
        panel.getAccessibleContext().setAccessibleParent(subPanel);
        panel = this.createButtonPanel();
        subPanel.add((Component)panel, "Last");
        panel.getAccessibleContext().setAccessibleParent(subPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)subPanel, "Center");
        subPanel.getAccessibleContext().setAccessibleParent(this);
        if (type == 2) {
            this.m_type.setText(VWResource.UserCentric);
        } else if (type == 1) {
            this.m_type.setText(VWResource.Work);
        }
        VWAccessibilityHelper.setAccessibility(this.m_type, null, this.m_type.getText(), this.m_type.getText());
        this.m_queueType = type;
        this.m_configNode = configNode;
        this.setLocationRelativeTo(parent);
        this.addKeyListener(VWKeyAdapter.s_keyAdapter);
    }

    public void releaseResources() {
        if (this.m_nameLabel != null) {
            this.m_nameLabel.removeAll();
            this.m_nameLabel = null;
        }
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_typeLabel != null) {
            this.m_typeLabel.removeAll();
            this.m_typeLabel = null;
        }
        if (this.m_type != null) {
            this.m_type.removeAll();
            this.m_type = null;
        }
        if (this.m_descriptionLabel != null) {
            this.m_descriptionLabel.removeAll();
            this.m_descriptionLabel = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_createButton != null) {
            this.m_createButton.removeActionListener(this);
            this.m_createButton.removeAll();
            this.m_createButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_configNode = null;
        this.removeAll();
    }

    protected JPanel createTopPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_nameLabel.setText(VWResource.s_label.toString(VWResource.QueueName));
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(4, 0, 4, 8);
            mainPanel.add((Component)this.m_nameLabel, gbConst);
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.m_nameTextField, gbConst);
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            this.m_typeLabel.setText(VWResource.s_label.toString(VWResource.QueueType));
            mainPanel.add((Component)this.m_typeLabel, gbConst);
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.m_type, gbConst);
            this.m_nameTextField.addKeyListener(this);
            this.m_nameTextField.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_nameLabel, mainPanel, VWResource.QueueName, VWResource.QueueName);
            VWAccessibilityHelper.setAccessibility(this.m_nameTextField, mainPanel, VWResource.QueueNameTextField, VWResource.QueueNameTextField);
            VWAccessibilityHelper.setLabelFor(this.m_nameLabel, this.m_nameTextField);
            VWAccessibilityHelper.setAccessibility(this.m_typeLabel, mainPanel, VWResource.QueueType, VWResource.QueueType);
            VWAccessibilityHelper.setAccessibility(this.m_type, mainPanel, this.m_type.getText(), this.m_type.getText());
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_nameLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_nameTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_typeLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_type.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createDescriptionPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            this.m_descriptionLabel.setText(VWResource.s_label.toString(VWResource.Description));
            mainPanel.add((Component)this.m_descriptionLabel, "First");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionLabel, mainPanel, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, mainPanel, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setLabelFor(this.m_descriptionLabel, this.m_descriptionTextArea);
            this.m_descriptionLabel.setLabelFor(this.m_descriptionTextArea);
            this.m_descriptionLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_descriptionTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_createButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_createButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setCreateButtonState();
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_createButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_createButton, mainPanel, this.m_createButton.getText(), this.m_createButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, mainPanel, this.m_cancelButton.getText(), this.m_cancelButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, mainPanel, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.setVisible(false);
        } else if (obj == this.m_createButton) {
            String nameText = this.m_nameTextField.getText();
            if (nameText == null || nameText.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.NameCanNotBeNull, null, 1, null);
            } else if (nameText.startsWith("F_", 0) || nameText.startsWith("f_", 0)) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidConfigName.toString(nameText), VWResource.ErrorMessage, 0);
            } else if (this.createQueue()) {
                this.setVisible(false);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc064.htm");
        } else if (obj == this.m_nameTextField) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public VWConfigQueueNode getQueueNode() {
        return this.m_newQueue;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        this.setCreateButtonState();
    }

    public void keyTyped(KeyEvent event) {
    }

    private void setCreateButtonState() {
        if (this.m_createButton == null) {
            return;
        }
        boolean bEnable = true;
        String tempString = null;
        if (this.m_nameTextField != null) {
            tempString = this.m_nameTextField.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_createButton.isEnabled() != bEnable) {
            this.m_createButton.setEnabled(bEnable);
        }
        if (this.m_createButton.isEnabled()) {
            this.getRootPane().setDefaultButton(this.m_createButton);
        } else {
            this.getRootPane().setDefaultButton(null);
        }
    }

    private boolean createQueue() {
        boolean bRet = false;
        try {
            String qName = this.m_nameTextField.getText();
            VWQueueDefinition qDef = null;
            if (this.m_queueType == 1) {
                VWConfigRegionNode regionNode = (VWConfigRegionNode)this.m_configNode;
                qDef = regionNode.getSystemConfiguration().createQueueDefinition(qName, this.m_queueType);
                qDef.setDescription(this.m_descriptionTextArea.getText());
                this.m_newQueue = new VWConfigQueueNode(regionNode.getSessionInfo(), qDef, regionNode.getServiceName(), regionNode.getRegionID(), 0, regionNode.getSystemConfiguration());
            } else {
                VWConfigRegionNode regionNode = (VWConfigRegionNode)this.m_configNode;
                qDef = regionNode.getSystemConfiguration().createQueueDefinition(qName, this.m_queueType);
                qDef.setDescription(this.m_descriptionTextArea.getText());
                this.m_newQueue = new VWConfigQueueNode(regionNode.getSessionInfo(), qDef, regionNode.getServiceName(), regionNode.getRegionID(), -1, regionNode.getSystemConfiguration());
            }
            bRet = true;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
        return bRet;
    }
}

